/*
 * platform_gpio.h
 *
 * Defines the interface for AXI GPIO control.
 */

#ifndef __PLATFORM_GPIO_H_
#define __PLATFORM_GPIO_H_

#include "xgpio.h"       // For XGpio driver
#include "xstatus.h"
#include "xparameters.h" // For XPAR_AXI_GPIO_0_DEVICE_ID

/*
 * Declare the global instance of the AXI GPIO driver.
 * It is defined in main.c and used in platform_gpio.c.
 */
extern XGpio Gpio;

/* AXI GPIO Configuration (must match main.c) */
#define AXI_GPIO_DEVICE_ID XPAR_AXI_GPIO_0_DEVICE_ID
#define AXI_GPIO_CHANNEL   1   // Using Channel 1 for output
#define LED_MASK           0x1 // Only the least significant bit (Bit 0) for 1-bit width

/* Function Prototypes */
void platform_init_gpios(void);
int toggle_leds(void);
unsigned int get_switch_state(void); // Placeholder

#endif // __PLATFORM_GPIO_H_
