/*
 * platform_gpio.c
 *
 * Implements the AXI GPIO control functions using the Xilinx Driver API.
 */

#include "platform_gpio.h"
#include "xil_printf.h"

/* Global state tracking for the single LED */
static u32 current_output_state = 0;

/**
 * @brief Sets the initial state of the AXI GPIO.
 * Assumes XGpio_Initialize and XGpio_SetDataDirection
 * have already been called in main.c.
 */
void platform_init_gpios(void) {
    /* Write initial state (LOW/OFF) to the AXI GPIO Data Register */
    XGpio_DiscreteWrite(&Gpio, AXI_GPIO_CHANNEL, 0x0);
    current_output_state = 0;

    xil_printf("AXI GPIO (1-bit) initial state set to OFF via driver.\r\n");
}

/**
 * @brief Toggles the state of the single LED pin (Bit 0).
 *
 * @return The new state (1 for ON, 0 for OFF).
 */
int toggle_leds(void) {
    /* Toggle the LSB state (0 -> 1 or 1 -> 0) */
    current_output_state = ~current_output_state & LED_MASK;

    /* Write the new state (0x1 or 0x0) to the AXI GPIO Data Register */
    XGpio_DiscreteWrite(&Gpio, AXI_GPIO_CHANNEL, current_output_state);

    /* Return the new state so the web server can send it back to the client */
    return (int)current_output_state;
}

/**
 * @brief Placeholder for reading switch state.
 */
unsigned int get_switch_state(void) {
    /* Not implemented for this demo */
    return 0;
}
