/**//*
Copyright © 2017, Numato Systems Private Limited. All rights reserved.

This software including all supplied files, Intellectual Property, know-how
or part of thereof as applicable (collectively called SOFTWARE) in source
and/or binary form with accompanying documentation is licensed to you by
Numato Systems Private Limited (LICENSOR) subject to the following conditions.

1. The LICENSOR retains the exclusive ownership of the SOFTWARE. This SOFTWARE
   is licensed to you and is not sold. The grant of this license is temporary
   and can be revoked by the LICENSOR at any time for any or no reason. Any
   units deployed (with this SOFTWARE in fully compiled binary form as part of
   your final application) while this license is granted to you may continue
   operating through the end of the unit's life beyond the revocation of this
   license.
2. You may use, modify, copy the SOFTWARE within your organization. This
   SOFTWARE shall not be transferred to third parties in any form except
   fully compiled binary form as part of your final application.
3. This SOFTWARE is licensed only to be used in connection with/executed on 
   supported products manufactured by Numato Systems Private Limited. 
   Using/executing this SOFTWARE on/in connection with custom or third party 
   hardware with out the LICENSOR's prior written permission is expressly 
   prohibited.
4. You may not download or otherwise secure a copy of this SOFTWARE for the
   purpose of competing with Numato Lab in any way such as but not limited to
   sharing the SOFTWARE with competitors, reverse engineering etc.. You may
   not do so even if you have no gain financial or otherwise from such action.
5. This SOFTWARE may contain contents from third parties. Such contents are 
   property of it's repective owners. And also those contents may be goverened
   by different license(s).   
6. DISCLAIMER
6.1. USING THIS SOFTWARE IS VOLUNTARY AND OPTIONAL. NO PART OF THIS SOFTWARE
     CONSTITUTE A PRODUCT OR PART OF PRODUCT SOLD BY THE LICENSOR.
6.2. THIS SOFTWARE AND DOCUMENTATION ARE PROVIDED “AS IS‿ WITH ALL FAULTS, 
     DEFECTS AND ERRORS AND WITHOUT WARRANTY OF ANY KIND.
6.3. THE LICENSOR DISCLAIMS ALL WARRANTIES EITHER EXPRESS OR IMPLIED, INCLUDING
     WITHOUT LIMITATION, ANY WARRANTY OF MERCHANTABILITY OR FITNESS FOR ANY
     PURPOSE.
6.4. IN NO EVENT, SHALL THE LICENSOR, IT’S PARTNERS OR DISTRIBUTORS BE LIABLE OR
     OBLIGATED FOR ANY DAMAGES, EXPENSES, COSTS, LOSS OF MONEY, LOSS OF TANGIBLE
     OR INTANGIBLE ASSETS DIRECT OR INDIRECT UNDER ANY LEGAL ARGUMENT SUCH AS BUT
     NOT LIMITED TO CONTRACT, NEGLIGENCE, STRICT LIABILITY, CONTRIBUTION, BREACH
     OF WARRANTY OR ANY OTHER SIMILAR LEGAL DEFINITION.
*/
`timescale 1ns / 1ps
module xobuslite_sync_phy #(
  parameter integer C_CLK_FREQ = 100_000_000
)
( 
  input clk,
  input rst,
    
  // Phy Write Channel
  output      wready,
  input       wvalid,
  input [7:0] wdata,
  
  // Phy Read Channel
  input        rready,
  output       rvalid,
  output [7:0] rdata,
  
  // FIFO external interface
  input  [7:0]data_i,
  output   [7:0]data_o,
  output   data_en,
  input       rxf_n,
  input       txe_n,
  output      rd_n,
  output      wr_n,
  output      oe_n,
  output      siwu,
  input       clkout 
);
    
reg  [7:0] data_o_q;
reg  data_en_q;
reg  wr_n_q, wr_n_s;
reg  rd_n_q, rd_n_s;
reg  oe_n_q, oe_n_s;

reg  [7:0] infifo_wdata;
wire [7:0] outfifo_rdata; 

reg  [2:0] state = IDLE;
reg  [2:0] next_state = IDLE;

wire outfifo_we, infifo_re;
reg  outfifo_re, infifo_we;

wire outfifo_writable, outfifo_readable;
wire infifo_writable,  infifo_readable;

assign outfifo_we = rvalid && wready ;
assign infifo_re  = rvalid && wready; 

assign wready = outfifo_writable;
assign rvalid = infifo_readable;

localparam  IDLE         = 3'h0,
            WRITE        = 3'h1,
            WR_DONE      = 3'h2,
            READ         = 3'h3,
            RD_DONE      = 3'h4;

// Instantiating Async fifo for phy write channel
asyncfifo outgoing_fifo(
        .we             (outfifo_we), 
        .writable       (outfifo_writable),    
        .re             (outfifo_re),
        .readable       (outfifo_readable),    
        .din            (wdata),
        .dout           (outfifo_rdata),
        .read_clk       (clkout),
        .read_rst       (rst),
        .write_rst      (rst),
        .write_clk      (clk));
    
// Instantiating Async fifo for phy read channel    
asyncfifo incoming_fifo(
        .we             (infifo_we),
        .writable       (infifo_writable),     
        .re             (infifo_re),
        .readable       (infifo_readable),     
        .din            (infifo_wdata),
        .dout           (rdata),
        .read_clk       (clk),
        .read_rst       (rst),
        .write_rst      (rst),
        .write_clk      (clkout)); 
 
wire pending_write  = (~txe_n && outfifo_readable);
wire pending_read   = (~rxf_n && infifo_writable);
    
assign siwu   = 1'b1;
assign wr_n   = wr_n_s;
assign rd_n   = ~rd_n_s;
assign oe_n   = ~oe_n_s;
assign data_en = data_en_q;
assign data_o = data_o_q;

always@(posedge clkout)
begin
  if(rst) begin
    rd_n_s  <=  1'b0;
    oe_n_s  <=  1'b0;
    data_en_q <=  1'b0;
    wr_n_s  <=  1'b1;        
    state   <=  IDLE; 
  end
  else begin        
    case(state) 
      IDLE   : begin
        rd_n_s      <=  1'b0;                    
        oe_n_s      <=  1'b0;
        data_en_q   <=  1'b0;
        infifo_we   <=  1'b0;  
        wr_n_s      <=  1'b1;
        outfifo_re  <=  1'b0;                   
        if(pending_read) begin
          oe_n_s    <=  1'b1;
          state     <=  READ;
        end
        else if(pending_write) begin
          oe_n_s    <=  1'b0;
          state     <=  WRITE;
          data_en_q <=  1'b0;
        end
      end
      
    WRITE   : begin
      if(pending_write) begin                        
        wr_n_s      <=  1'b0;
        data_en_q   <=  1'b1;
        data_o_q    <=  outfifo_rdata;
        outfifo_re  <=  1'b1;                         
        state       <=  WR_DONE;                       
      end
      else begin
        state       <=  IDLE;
        wr_n_s      <=  1'b1;
        data_en_q   <=  1'b0;
        outfifo_re  <=  1'b0;
      end
    end
                
    WR_DONE : begin
      state         <=  IDLE;                    
      oe_n_s        <=  1'b1;
      wr_n_s        <=  1'b1;
      outfifo_re    <=  1'b0;
      data_en_q     <=  1'b0;
    end
                
    READ    : begin
      if(pending_read) begin
        infifo_we    <=  1'b0;
        rd_n_s       <=  1'b1;
        oe_n_s       <=  1'b1;
        infifo_wdata <= data_i;
        state        <=  RD_DONE;
      end
      else begin
        state        <=  IDLE;
        oe_n_s       <=  1'b0;
      end
    end
                
    RD_DONE : begin
      infifo_we      <=  1'b1;
      rd_n_s         <=  1'b0;
      oe_n_s         <=  1'b0;
      state          <=  IDLE;
    end
                
    default : begin
      rd_n_s        <=  1'b0;                    
      oe_n_s        <=  1'b0;
      data_en_q     <=  1'b0;
      infifo_we     <=  1'b0;  
      wr_n_s        <=  1'b1;
      outfifo_re    <=  1'b0;                   
      if(pending_read) begin
        oe_n_s      <=  1'b1;
        state       <=  READ;
      end
      else if(pending_write) begin
        oe_n_s      <=  1'b0;
        state  <=  WRITE;
        data_en_q   <=  1'b0;
      end
    end
    endcase
  end
end
endmodule

