`timescale 1ns / 1ps
module xobus_phy_top(
  input clk,
  input rst,

  // FIFO external interface
  inout  [7:0] data,
  input       rxf_n,
  input       txe_n,
  output      rd_n,
  output      wr_n,
  output      oe_n,
  output      siwu,
  input       clkout
  );
  
  wire [7:0] rdata, wdata;
  wire [7:0]  data_o;
  wire [7:0] data_i;
  wire data_t ;


    assign data_i = data; 

assign  data   = data_t ? data_o : 8'hzz;
 
  
 /* ila_0 ila0 b
  .clk(clkout),
  .probe0(data),
  .probe1(rxf_n),
  .probe2(txe_n),
  .probe3(rd_n),
  .probe4(wr_n),
  .probe5(oe_n)
  );
  
  ila_1 ila1(
  .clk(clk),
  .probe0(wdata),
  .probe1(rdata),
  .probe2(wvalid),
  .probe3(wready),
  .probe4(rready),
  .probe5(rvalid)
  ); */
//    IOBUF #(
//     .DRIVE(12), // Specify the output drive strength
//     .IBUF_LOW_PWR("TRUE"),  // Low Power - "TRUE", High Performance = "FALSE" 
//     .IOSTANDARD("DEFAULT"), // Specify the I/O standard
//     .SLEW("SLOW") // Specify the output slew rate
//  ) IOBUF_inst (
//     .O(data_o),     // Buffer output
//     .IO(data),   // Buffer inout port (connect directly to top-level port)
//     .I(data_i),     // Buffer input
//     .T(data_t)      // 3-state enable input, high=input, low=output
//  );
  xobuslite_sync_phy xobuslite_phy (
        .clk(clk),
        .rst(~rst),
      
        .rready(rready),
        .rvalid(rvalid),
        .rdata(rdata),
      
        .wready(wready),
        .wvalid(wvalid),
        .wdata(wdata),
      
        .data_i(data_i),
        .data_o(data_o),
        .data_en(data_t),
       // .data(data),
        .rxf_n(rxf_n),
        .txe_n(txe_n),
        .rd_n(rd_n),
        .wr_n(wr_n),
        .oe_n(oe_n),
        .siwu(siwu),
        .clkout(clkout)
      );
      
 sync_phy_driver sync_driver(
          .rready(rready),
         .rvalid(rvalid),
         .rdata(rdata),
       
         .wready(wready),
         .wvalid(wvalid),
         .wdata(wdata)
         );      
endmodule
