library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
Library UNISIM;
use UNISIM.vcomponents.all;

entity topmodule is
     Port ( clk_in   : in   STD_LOGIC;
            reset    : in   std_logic;
            -- HDMI0    
            data0_p  : out  STD_LOGIC_VECTOR(2 downto 0);
            data0_n  : out  STD_LOGIC_VECTOR(2 downto 0);
            clk0_p   : out  std_logic;
            clk0_n   : out  std_logic;
            -- HDMI1
            data1_p  : out  STD_LOGIC_VECTOR(2 downto 0);
            data1_n  : out  STD_LOGIC_VECTOR(2 downto 0);
            clk1_p   : out  std_logic;
            clk1_n   : out  std_logic
          );
end topmodule;

architecture Behavioral of topmodule is
   component clocking
   port (
      -- Clock in ports
      clk_in           : in  std_logic;
      -- Clock out ports
      CLK_DVI          : out std_logic;
      CLK_DVIn         : out std_logic;
      CLK_VGA          : out std_logic;
      reset            : in  std_logic
      );
   end component;
    component dvid_test
    port (
      clk_dvi : in   STD_LOGIC;
      clk_dvin: in   STD_LOGIC;
      clk_vga : in   STD_LOGIC;
      data_p  : out  STD_LOGIC_VECTOR(2 downto 0);
      data_n  : out  STD_LOGIC_VECTOR(2 downto 0);
      clk_p   : out  std_logic;
      clk_n   : out  std_logic
   );
    end component;

   signal clk_dvi  : std_logic := '0';
   signal clk_dvin : std_logic := '0';
   signal clk_vga  : std_logic := '0';
begin
    
clocking_inst : clocking port map (
      clk_in   => clk_in,
      -- Clock out ports
      CLK_DVI  => clk_dvi,  -- for 640x480@60Hz : 125MHZ
      CLK_DVIn => clk_dvin, -- for 640x480@60Hz : 125MHZ, 180 degree phase shift
      CLK_VGA  => clk_vga,   -- for 640x480@60Hz : 25MHZ 
      reset    => reset
    );

hdmi0: dvid_test PORT MAP(
        clk_dvi  => clk_dvi,
        clk_dvin => clk_dvin, 
        clk_vga  => clk_vga,
        data_p  => data0_p,
        data_n  => data0_n,
        clk_p       => clk0_p,
        clk_n       => clk0_n
        );
        
hdmi1: dvid_test PORT MAP(
        clk_dvi  => clk_dvi,
        clk_dvin => clk_dvin, 
        clk_vga  => clk_vga,
        data_p  => data1_p,
        data_n  => data1_n,
        clk_p       => clk1_p,
        clk_n       => clk1_n
        );
end Behavioral;

