--------------------------------------------------------------------------------
-- Author  : Rohit Singh
-- Module  : ft2232h_phy_top - rtl
-- Project : FIXME

-- License : The MIT License
-- Copyright � 2015, 2016 Rohit K. Singh
--------------------------------------------------------------------------------

library IEEE;

use IEEE.STD_LOGIC_1164.all;
use IEEE.NUMERIC_STD.all;

entity ft2232h_phy_top is
  port(
    clk : in std_logic;
    rst : in std_logic;

    -- FTDI FIFO external interface
    data  : inout std_logic_vector(7 downto 0);
    rxf_n : in    std_logic;
    txe_n : in    std_logic;
    rd_n  : out   std_logic; 
    wr_n  : out   std_logic
    );
end ft2232h_phy_top;

architecture rtl of ft2232h_phy_top is

  component ft2232h_phy_driver
    port(
      clk    : in  std_logic;
      rst    : in  std_logic;
      rvalid : in  std_logic;
      rdata  : in  std_logic_vector(7 downto 0);
      wready : in  std_logic;
      rready : out std_logic;
      wvalid : out std_logic;
      wdata  : out std_logic_vector(7 downto 0)
      );
  end component;

  component ft2232h_phy
    port(
      clk : in std_logic;
      rst : in std_logic;

      rready : in  std_logic;
      wvalid : in  std_logic;
      wdata  : in  std_logic_vector(7 downto 0);
      rvalid : out std_logic;
      rdata  : out std_logic_vector(7 downto 0);
      wready : out std_logic;

      rxf_n : in    std_logic;
      txe_n : in    std_logic;
      data  : inout std_logic_vector(7 downto 0);
      rd_n  : out   std_logic;
      wr_n  : out   std_logic
      );
  end component;

  signal rready : std_logic                    := '0';
  signal rvalid : std_logic                    := '0';
  signal rdata  : std_logic_vector(7 downto 0) := (others => '0');

  signal wready : std_logic                    := '0';
  signal wvalid : std_logic                    := '0';
  signal wdata  : std_logic_vector(7 downto 0) := (others => '0');
  
  signal rst_n : std_logic := not rst;

begin

  Inst_ft2232h_phy_driver : ft2232h_phy_driver port map(
    clk    => clk,
    rst    => rst_n,
    rready => rready,
    rvalid => rvalid,
    rdata  => rdata,
    wready => wready,
    wvalid => wvalid,
    wdata  => wdata
    );

  Inst_ft2232h_phy : ft2232h_phy port map(
    clk    => clk,
    rst    => rst_n,
    rready => rready,
    rvalid => rvalid,
    rdata  => rdata,
    wready => wready,
    wvalid => wvalid,
    wdata  => wdata,
    data   => data,
    rxf_n  => rxf_n,
    txe_n  => txe_n,
    rd_n   => rd_n,
    wr_n   => wr_n
    );
end rtl;
