--------------------------------------------------------------------------------
-- Author  : Rohit Singh
-- Module  : ft2232h_phy_driver - rtl
-- Project : FIXME

-- License : The MIT License
-- Copyright � 2015, 2016 Rohit K. Singh
--------------------------------------------------------------------------------

library IEEE;

use IEEE.STD_LOGIC_1164.all;
use IEEE.NUMERIC_STD.all;

entity ft2232h_phy_driver is
  port(
    clk : in std_logic;
    rst : in std_logic;

    -- read channel
    rready : out std_logic;
    rvalid : in  std_logic;
    rdata  : in  std_logic_vector(7 downto 0);

    -- write channel
    wready : in  std_logic;
    wvalid : out std_logic;
    wdata  : out std_logic_vector(7 downto 0)
    );
end ft2232h_phy_driver;

architecture rtl of ft2232h_phy_driver is

  type ops is (OP_READ, OP_WRITE);
  signal op : ops := OP_READ;

  signal data : unsigned(7 downto 0) := (others => '0');

begin

  main : process(clk, rst)
  begin

    if rst = '1' then
      op     <= OP_READ;
      data   <= (others => '0');
      rready <= '0';
      wvalid <= '0';

    elsif rising_edge(clk) then
      rready <= '0';
      wvalid <= '0';

      case op is
        when OP_READ =>
          if rvalid = '1' then
            data   <= unsigned(rdata);
            rready <= '1';
            op     <= OP_WRITE;
          end if;

        when OP_WRITE =>
          if wready = '1' then
            wdata  <= std_logic_vector(data);
            wvalid <= '1';
            op     <= OP_READ;
          end if;

      end case;

    end if;

  end process;

end rtl;
