
module vga_to_hdmi(
    input wire pixclk,      // 25MHz
    input wire clk_hdmi,    // 125MHz
    input wire hsync,
    input wire vsync,
    input wire active,
    input wire [7:0]red,
    input wire [7:0]green,
    input wire [7:0]blue,
    output [1:0]red_s,
    output [1:0]green_s,
    output [1:0]blue_s,
    output [1:0]clock
);

wire [9:0] TMDS_red, TMDS_green, TMDS_blue;
reg  [9:0] shift_red = 0, shift_green = 0, shift_blue = 0;
reg  [3:0] TMDS_mod10;  // modulus 10 counter

TMDS_encoder encode_R(.clk(pixclk), .data(red  ), .c(2'b00)        , .blank(active), .encoded(TMDS_red));
TMDS_encoder encode_G(.clk(pixclk), .data(green), .c(2'b00)        , .blank(active), .encoded(TMDS_green));
TMDS_encoder encode_B(.clk(pixclk), .data(blue ), .c({vsync,hsync}), .blank(active), .encoded(TMDS_blue));


always@(posedge clk_hdmi)
begin
    shift_red   <= (TMDS_mod10==4'd8) ? TMDS_red   : shift_red    [9:2];
    shift_green <= (TMDS_mod10==4'd8) ? TMDS_green : shift_green  [9:2];
    shift_blue  <= (TMDS_mod10==4'd8) ? TMDS_blue  : shift_blue   [9:2];
    TMDS_mod10  <= (TMDS_mod10==4'd8) ? 4'd0 : TMDS_mod10+4'd2;
end

assign red_s   = shift_red[1:0];
assign green_s = shift_green[1:0];
assign blue_s  = shift_blue[1:0];
assign clock   = {pixclk, pixclk}; 

endmodule 