-----------------------------------------------------------------------------
-- File : vga_gen.vhd
--
-- Author : Mike Field <hamster@snap.net.nz>
--
-- Date   : 30th June 2015
--
-- Generate the VGA 640x480 timing signals.
-- 
-----------------------------------------------------------------------------
library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.NUMERIC_STD.ALL;

entity vga_gen is
    Port ( clk : in STD_LOGIC;
           blank : out STD_LOGIC := '0';
           hsync : out STD_LOGIC := '0';
           vsync : out STD_LOGIC := '0');
end vga_gen;

architecture Behavioral of vga_gen is
    signal x : unsigned(11 downto 0) := (others => '0');
    signal y : unsigned(11 downto 0) := (others => '0');
begin

clk_proc: process(clk)
    begin
        if rising_edge(clk) then
            if x = 640 then
                blank <= '1';
            elsif x = 800-1 and (y < 480-1 or y = 525-1) then
                blank <= '0';            
            end if;
            
            if x = 640+16-1 then
                hsync <= '1';
            elsif x = 640+16+96-1 then
                hsync <= '0';
            end if;

            if x = 800-1 then 
                x <= (others => '0');
                
                if y = 480+10-1 then
                    vsync  <= '1';
                elsif y = 420+10+2-1 then
                    vsync  <= '0';
                end if;
                
                if y = 525-1 then
                    y <= (others => '0');
                else
                    y <= y +1;
                end if;
            else
                x <= x + 1;        
            end if;            
        end if;            
    end process;
end Behavioral;

