module hdmi_out 
        (
        input wire CLK100MHZ,   
        //HDMI output
        output wire [2:0]hdmi_tx,
        output wire hdmi_tx_clk
       );
       

wire hsync;
wire vsync;
wire active;
wire vsync_in;
wire hsync_in;
wire blank_in;
wire [7:0] Red;
wire [7:0] Green;
wire [7:0] Blue;
reg  [7:0] count;
wire [1:0] blue_s;
wire [1:0] green_s;
wire [1:0] red_s;
wire [1:0] clock;
wire clk_pixel;
wire clk_hdmi;
wire w_locked;

alt_pll mypll_inst(
            .inclk0 ( CLK100MHZ),
            .c0     ( clk_hdmi ),  //25MHz
            .c1     ( clk_pixel),   //125MHz
            .locked ( w_locked )
            );

wire pixel_clk5; 
wire pixel_clk; 
 
assign pixel_clk5 = clk_hdmi;
assign pixel_clk  = clk_pixel;
 
always@(posedge pixel_clk)
begin
    if(blank_in)
        count <= 0;
    else
        count   <= count + 1'b1;
end

vga_gen vga_gen_inst(
    .clk    (pixel_clk),
    .blank  (blank_in),
    .hsync  (hsync_in),
    .vsync  (vsync_in)
    );
    
vga_output vga_output_inst(
    .clk      (pixel_clk),
    .hsync_in (hsync_in),
    .vsync_in (vsync_in),
    .blank_in (blank_in),
    .count    (count),
    .vga_hsync(hsync),
    .vga_vsync(vsync),
    .vga_red  (Red),
    .vga_green(Green),
    .vga_blue (Blue),
    .vga_blank(active)
    );

vga_to_hdmi vga_to_hdmi_inst(
    .pixclk  ( pixel_clk ),
    .clk_hdmi( pixel_clk5 ),
    
    // vga timing signals
    .hsync   ( hsync ),
    .vsync   ( vsync ),
    .active  (~active ),
    
    // Input rgb data
    .red     ( Red ),
    .green   ( Green ),
    .blue    ( Blue ),
    
    // Encoded shift data to serializer
    .blue_s  ( blue_s),
    .red_s   ( red_s),
    .green_s ( green_s),
    
    // Encoded shift clock to serializer
    .clock   ( clock)
    );
    
ddio_out ddio_out_r  (.outclock(pixel_clk5),    .din(red_s),    .pad_out(hdmi_tx[2]));
ddio_out ddio_out_g  (.outclock(pixel_clk5),    .din(green_s),  .pad_out(hdmi_tx[1]));
ddio_out ddio_out_b  (.outclock(pixel_clk5),    .din(blue_s),   .pad_out(hdmi_tx[0]));
ddio_out ddio_out_clk(.outclock(pixel_clk5),    .din(clock),    .pad_out(hdmi_tx_clk));

endmodule 